{*
 * Projecte Fressa a LINKAT
 * GLOBUS3
 * Data inici: 23/12/2002
 * Ultim dia:  25/12/2002
 *
 * @author Jordi Lagares Roset "jlagares@xtec.cat - www.lagares.org"
 * amb el suport del Departament d'Educacio de la Generalitat de Catalunya
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details (see the LICENSE file).
 *}

unit UnitMatematiques;

{*******************************************************}
interface
{*******************************************************}

const
  MaximBufferDeDades = 1024;   //Nombre mxim de dades en el Buffer d'entrada

type
  //PSoReal = ^SoReal;
  SoReal = array[1..MaximBufferDeDades] of single;

{ FFT
 -No es pot entrar un Buffer de dades amb nmero de dades superior a MaximBufferDeDades
 -Si es vol fer servir els procediments anteriors, cal fer-ho amb l'ordre mostrat
 -DR Significa Dades Reals, sn les dades de so inicials. El calculFFT torna els quoeficients FFT en aquesta variable
 -Es recorda que de Quoeficients FFT en tornan la meitat de les dades entrades
}
Procedure CalculPreemfasis(var DR:SoReal; GrandariaBuffer:LongInt);
Procedure CalculFinestradeHamming(var DR:SoReal; GrandariaBuffer:LongInt);
//procedure CalculFft(var DR:SoReal; GrandariaBuffer:LongInt);
Procedure CalculFrequenciesCoeficientsFourier(var FrequenciesCoeficientsFourier:SoReal; GrandariaBuffer:LongInt;Muestras:LongInt);
Procedure CalculCoeficientsFourierAdaptatsALOida(var CoeficientsFourierAdaptats,FrequenciesCoeficientsFourier:SoReal; GrandariaBuffer:LongInt);

{ LPC
 -DR Si posa les dades de so amb tans de dades com, GrandariaBuffer, diu (com a mxim MaximBufferDeDades)
  calculan tans de quoeficnets LPC com, NumeroDeQuoeficientsLPC, diu (com a mxim MaximP)
}
const
  MaximP = 64;                 //Nombre mxim de quoficients LPC a poder calcular

procedure CalculQuoeficientsLPC(var DR:SoReal;GrandariaBuffer:LongInt;NumeroDeQuoeficientsLPC:integer);

{*******************************************************}
implementation
{*******************************************************}

var
  FrequenciaMaximaAZero,FrequenciaMinimaAZero:integer;

Procedure CalculPreemfasis(var DR:SoReal; GrandariaBuffer:LongInt);
var
  Comodi1,Comodi2:single;
  Preemphasis:single;
  i:integer;
begin
  Comodi1:=0.;
  Comodi2:=0.;
  Preemphasis:=0.95;
  for i:=1 to GrandariaBuffer do begin
    Comodi1:= DR[i];
    DR[i]:= DR[i]-Preemphasis*Comodi2;
    Comodi2:=Comodi1;
  end;
end;

Procedure CalculFinestradeHamming(var DR:SoReal; GrandariaBuffer:LongInt);
var
  GrandariaBufferPartitPer2:integer;
  DosPiPartitPerN:Single;
  i:integer;
begin
  DosPiPartitPerN:=2*3.1416/GrandariaBuffer;
  GrandariaBufferPartitPer2:=GrandariaBuffer div 2;
  for i:=1 to GrandariaBuffer do DR[i]:= DR[i]*(0.54+0.46*cos(DosPiPartitPerN*(i-GrandariaBufferPartitPer2)));
end;

Procedure CalculFrequenciesCoeficientsFourier(var FrequenciesCoeficientsFourier:SoReal; GrandariaBuffer:LongInt;Muestras:LongInt);
var
  i:integer;
  Comodi:single;
begin
  Comodi:=Muestras/GrandariaBuffer;
  For i:=1 to round(GrandariaBuffer/2) do begin
    //CoeficientsFourier,i-1]:=(i-1)*Comodi;
    FrequenciesCoeficientsFourier[i]:=(i-1)*Comodi;
  end;
end;

Procedure CalculCoeficientsFourierAdaptatsALOida(var CoeficientsFourierAdaptats,FrequenciesCoeficientsFourier:SoReal; GrandariaBuffer:LongInt);
var
  i:integer;
begin
  CoeficientsFourierAdaptats[1]:=0;
  for i:=2 to round(GrandariaBuffer/2) - 1 do
  if CoeficientsFourierAdaptats[i]>0 then CoeficientsFourierAdaptats[i]:=CoeficientsFourierAdaptats[i]/(79.1874212*exp(-0.800147*ln(FrequenciesCoeficientsFourier[i])));
end;
{
procedure CalculFft(var DR:SoReal; GrandariaBuffer:LongInt);
var
  m,irem,l,le,le1,i,j,k,ip,n:integer;
  ur,ui,wr,wi,tr,ti,temp:single;
  comodi:single;
  NombreDades:integer;
  DI: SoReal;

begin
  for i:=1 to GrandariaBuffer do DI[i]:= 0.;
//Clcul FFT
  j:=1;
  comodi:=0.5;
  for i:=1 to GrandariaBuffer-1 do begin
    if i<j then begin
      tr:=DR[j];
      ti:=DI[j];
      DR[j]:=DR[i];
      DI[j]:=DI[i];
      DR[i]:=tr;
      DI[i]:=ti;
      k:=round(GrandariaBuffer*comodi);
      while k<j do begin
        j:=j-k;
        k:=round(k*comodi);
      end;
    end else begin
      k:=round(GrandariaBuffer*comodi);
      while k<j do begin
        j:=j-k;
        k:=round(k*comodi);
      end;
    end;
    j:=j+k;
  end;
  m:=0;
  irem:=GrandariaBuffer;
  while irem>1 do begin
    irem:=round(irem*comodi);
    m:=m+1;
  end;
  for l:=1 to m do begin
    le:=round(exp(l*ln(2)));
    le1:=round(le*comodi);
    ur:=1.0;
    ui:=0;
    wr:=cos(pi/le1);
    wi:=-sin(pi/le1);
    for j:=1 to le1 do begin
      i:=j;
      while i<=GrandariaBuffer do begin
        ip:=i+le1;
        tr:=DR[ip]*ur-DI[ip]*ui;
        ti:=DI[ip]*ur+DR[ip]*ui;
        DR[ip]:=DR[i]-tr;
        DI[ip]:=DI[i]-ti;
        DR[i]:=DR[i]+tr;
        DI[i]:=DI[i]+ti;
        i:=i+le;
      end;
      temp:=ur*wr-ui*wi;
      ui:=ui*wr+ur*wi;
      ur:=temp;
    end;
  end;
  NombreDades:=Round(GrandariaBuffer/2);
  for i:=1 to GrandariaBuffer do begin
    DR[i]:=DR[i]/GrandariaBuffer;
    DI[i]:=DI[i]/GrandariaBuffer;
  end;
  for i:=NombreDades+1 to GrandariaBuffer do begin
    DR[i]:=0;
    DI[i]:=0;
  end;
  //Comodi:=Muestras/GrandariaBuffer;
  For i:=1 to NombreDades do begin
    //CoeficientsDenFourier[1,i-1]:=(i-1)*Comodi;
    //CoeficientsDenFourier[2,i-1]:=SQRT(DR[i]*DR[i]+DI[i]*DI[i]);
    DR[i]:=SQRT(DR[i]*DR[i]+DI[i]*DI[i]);
  end;
end;
}
procedure CalculQuoeficientsLPC(var DR:SoReal;GrandariaBuffer:LongInt;NumeroDeQuoeficientsLPC:integer);
const
  N = MaximBufferDeDades; //Nombre de dades
var
  x:array[0..N] of single;
  q:array[0..MaximP] of single;
  r:array[0..MaximP] of single;
  E:array[0..MaximP] of single;
  alfa:array[1..MaximP,1..MaximP] of single;
  k:array[1..MaximP] of single; //PARCOR Coefficients
  a:array[1..MaximP] of single; //Coeficients LPC
  g:array[1..MaximP] of single; //Log area ratio coefficients
  h:array[0..N] of single;      //Funci de transferncia
var
  P:integer;
  i,j:integer;
  m:integer;
  pr,pi:single;
  Nm:integer;
  CalculsDePi:single;
  CalculsDePiPerM:single;
begin
  //for i:=0 to N do DadesInicalsLPC[i]:=0;

  for i:=0 to N do x[i]:=0;
  for i:=0 to MaximP do r[i]:=0;

  P:=NumeroDeQuoeficientsLPC;
  Nm:=GrandariaBuffer-1;
  //for i:=0 to Nm do x[i]:=DadesInicalsLPC[i];
  for i:=1 to GrandariaBuffer do x[i-1]:=DR[i];
  for i:=0 to P do q[i]:=0;
  //for i:=0 to P do q[i]:=0;
  //Calcul dels quoeficients d'autocorrelaci
  for i:=0 to P do r[i]:=0;
  for m:=0 to P do for i:=0 to N-1-m do r[m]:=r[m]+x[i]*x[i+m];
  if r[0]=0 then begin
    for i:=0 to Nm do DR[i+1]:=0;
    exit;
  end;
  //LPC Anlisi. Mtode de Levinson-Durbin
  E[0]:=r[0];
  k[1]:=r[1]/E[0];
  alfa[1,1]:=k[1];
  E[1]:=(1-k[1]*k[1])*E[0];
  for i:=2 to P do begin
    k[i]:=0;
    for j:=1 to i-1 do k[i]:=k[i]+alfa[j,i-1]*r[i-j];
    k[i]:=(r[i]-k[i])/E[i-1];
    alfa[i,i]:=k[i];
    for j:=1 to i-1 do alfa[j,i]:=alfa[j,i-1]-k[i]*alfa[i-j,i-1];
    E[i]:=(1-k[i]*k[i])*E[i-1];
  end;
  // a coeficients LPC
  for i:=1 to P do a[i]:=alfa[i,P];
  //K[i] PARCOR Coefficients
  //log area ratio coefficients
  for i:=1 to P do g[i]:=ln((1-k[i])/(1+k[i]))/ln(10);
  //Funci de transferncia
  //Nm:=N;
  //Nm:=(Nm-1) div 2;
  //Nm:=(Nm div 2)-1;
  Nm:=((Nm+1) div 2)-1;
  CalculsDePi:=3.1416/Nm;
  for m:=0 to Nm do begin
    Pr:=1;
    Pi:=0;
    CalculsDePiPerM:=m*CalculsDePi;
    for i:=1 to P do begin
      Pr:=Pr-a[i]*cos(i*CalculsDePiPerM);
      Pi:=Pi+a[i]*sin(i*CalculsDePiPerM);
    end;
    //es pot calcular el logaritme decimal
    H[m]:=1/sqrt(Pr*Pr+Pi*Pi);
    //4 Quoeficient que m'he inventat d'ajust
    DR[m+1]:=4*H[m];
  end;
end;

end.
